//
//    Copyright (C) Microsoft.  All rights reserved.
//
//+---------------------------------------------------------------
//
//  File:       idxcntrs.h
//
//  Contents:   Constants for Performance Monitoring
//
//  History:    9/25/2001 5:31:32 PM  Generated by makeini.vbs
//
//---------------------------------------------------------------

#define OBJECT_INDEXER_PLUGIN                             0

//
// Perf counters related to indexing
//
#define COUNTER_IDXPI_MIN_COUNTER                         2
#define COUNTER_IDXPI_MASTER_INDEX_LEVEL                  2
#define COUNTER_IDXPI_NUM_MASTER_MERGES_TO_DATE           4
#define COUNTER_IDXPI_MASTER_MERGE_PROGRESS               6
#define COUNTER_IDXPI_SHADOW_MERGE_LEVELS                 8
#define COUNTER_IDXPI_SHADOW_MERGE_LEVEL_THRESHOLD       10
#define COUNTER_IDXPI_NUM_PERSISTENT_INDEXES             12
#define COUNTER_IDXPI_INDEX_SIZE                         14
#define COUNTER_IDXPI_NUM_UNIQUE_KEY                     16
#define COUNTER_IDXPI_NUM_DOCUMENTS_INDEXED              18
#define COUNTER_IDXPI_NUM_WI_CREATED                     20
#define COUNTER_IDXPI_NUM_WI_DELETED                     22
#define COUNTER_IDXPI_NUM_WIDSET_CLEAN                   24
#define COUNTER_IDXPI_NUM_WIDSET_DIRTY                   26
#define COUNTER_IDXPI_NUM_MASTER_MERGES_NOW              28

//
// Perf counters related to queries
//
#define COUNTER_IDXPI_ACTIVE_CONNECTIONS                 30
#define COUNTER_IDXPI_NUM_QUERIES                        32
#define COUNTER_IDXPI_NUM_FAILED_QUERIES                 34
#define COUNTER_IDXPI_NUM_SUCCEEDED_QUERIES              36

//
// The following counters are for each merge level
//

//
// Flush (level 0).
//

#define COUNTER_IDXPI_NUM_INDEXES_L0                     38
#define COUNTER_IDXPI_NUM_MERGES_NOW_L0                  40
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L0             42
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L0              44
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L0                46

#define COUNTER_IDXPI_NUM_INDEXES_L1                     48
#define COUNTER_IDXPI_NUM_MERGES_NOW_L1                  50
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L1             52
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L1              54
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L1                56

#define COUNTER_IDXPI_NUM_INDEXES_L2                     58
#define COUNTER_IDXPI_NUM_MERGES_NOW_L2                  60
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L2             62
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L2              64
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L2                66

#define COUNTER_IDXPI_NUM_INDEXES_L3                     68
#define COUNTER_IDXPI_NUM_MERGES_NOW_L3                  70
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L3             72
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L3              74
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L3                76

#define COUNTER_IDXPI_NUM_INDEXES_L4                     78
#define COUNTER_IDXPI_NUM_MERGES_NOW_L4                  80
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L4             82
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L4              84
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L4                86

#define COUNTER_IDXPI_NUM_INDEXES_L5                     88
#define COUNTER_IDXPI_NUM_MERGES_NOW_L5                  90
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L5             92
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L5              94
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L5                96

#define COUNTER_IDXPI_NUM_INDEXES_L6                     98
#define COUNTER_IDXPI_NUM_MERGES_NOW_L6                 100
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L6            102
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L6             104
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L6               106

#define COUNTER_IDXPI_NUM_INDEXES_L7                    108
#define COUNTER_IDXPI_NUM_MERGES_NOW_L7                 110
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L7            112
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L7             114
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L7               116

#define COUNTER_IDXPI_NUM_INDEXES_L8                    118
#define COUNTER_IDXPI_NUM_MERGES_NOW_L8                 120
#define COUNTER_IDXPI_MERGE_SPEED_AVERAGE_L8            122
#define COUNTER_IDXPI_NUM_MERGES_TO_DATE_L8             124
#define COUNTER_IDXPI_MERGE_SPEED_LAST_L8               126

#define COUNTER_IDXPI_MAX_COUNTER                       126
#define NUM_OBJECT_INDEXER_PLUGIN ( 1 + ( COUNTER_IDXPI_MAX_COUNTER - COUNTER_IDXPI_MIN_COUNTER ) / 2 )

