<?php
// =====================================
// BIAWAK SCANNER
// =====================================

@error_reporting(0);
@ini_set('display_errors', 0);
@set_time_limit(0);
@ignore_user_abort(true);

$start_dir = __DIR__;

$skip_folders = array(
  'node_modules','vendor','.git','cache','caches','backup','backups','wp-content/cache'
);

$ext_allow = array('php','phtml','php3','php4','php5','php7','inc');

$MAX_FILE_SIZE = 8 * 1024 * 1024;

$patterns = array(
  'eval'             =>
'/\beval\s*\(/i', 'assert' => '/\bassert\s*\(/i', 'base64_decode' => '/base64_decode\s*\(/i', 'gzinflate' =>
'/gzinflate\s*\(/i', 'gzuncompress' => '/gzuncompress\s*\(/i', 'str_rot13' => '/str_rot13\s*\(/i', 'shell_exec' =>
'/\bshell_exec\s*\(/i', 'system' => '/\bsystem\s*\(/i', 'passthru' => '/\bpassthru\s*\(/i', 'exec' => '/\bexec\s*\(/i',
'proc_open' => '/\bproc_open\s*\(/i', 'popen' => '/\bpopen\s*\(/i', 'preg_replace_/e' =>
'/preg_replace\s*\(.*\/e[\'"]/is', 'superglobal_cmd' => '/\$_(GET|POST|REQUEST)\s*\[[^\]]+\]/i', 'remote_fetch' =>
'/(file_get_contents|curl_exec)\s*\(\s*[\'"]https?:\/\//i', 'obfusc_hex' => '/(\\\\x[0-9a-f]{2}){3,}/i', 'goto_obfusc'
=> '/\bgoto\s+[A-Za-z0-9_]+\s*;/i', 'webshell_names' => '/\b(c99|r57|wso|b374k|indoxploit|weevely)\b/i', ); function
should_skip($path, $skip_folders) { $lower = strtolower($path); foreach ($skip_folders as $sf) { if ($sf !== '' &&
strpos($lower, strtolower($sf)) !== false) return true; } return false; } function safe_read($path, $maxSize) { $sz =
@filesize($path); if ($sz === false || $sz <= 0 || $sz > $maxSize) return array(false, 0); $c =
@file_get_contents($path); if ($c === false) return array(false, (int)$sz); return array($c, (int)$sz); } function
h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); } $hits = array(); $total_scanned = 0; $it = new
RecursiveIteratorIterator( new RecursiveDirectoryIterator($start_dir, FilesystemIterator::SKIP_DOTS),
RecursiveIteratorIterator::SELF_FIRST ); foreach ($it as $fileinfo) { if (!$fileinfo->isFile()) continue; $path =
$fileinfo->getPathname(); if (should_skip($path, $skip_folders)) continue; $ext = strtolower(pathinfo($path,
PATHINFO_EXTENSION)); if (!in_array($ext, $ext_allow, true)) continue; $total_scanned++; list($content, $size) =
safe_read($path, $MAX_FILE_SIZE); if ($content === false) continue; foreach ($patterns as $name => $rx) { if
(@preg_match($rx, $content, $m, PREG_OFFSET_CAPTURE)) { $pos = isset($m[0][1]) ? (int)$m[0][1] : 0; $start = max(0, $pos
- 60); $snippet = substr($content, $start, 160); $snippet = str_replace(array("\r","\n","\t"), ' ', $snippet); $hits[] =
array( 'match' => $name, 'path' => $path, 'size' => (int)$size, 'mtime' => @filemtime($path) ? (int)@filemtime($path) :
0, 'snippet' => $snippet, ); break; } } } usort($hits, function($a, $b) { $am = isset($a['mtime']) ? (int)$a['mtime'] :
0; $bm = isset($b['mtime']) ? (int)$b['mtime'] : 0; if ($am === $bm) return 0; return ($am < $bm) ? 1 : -1; }); ?>
<!doctype html>
<html>
    <head>
        <meta charset="utf-8" />
        <title>𓆌🔍𓆌 BIAWAK LOOKING FOR 𓆌🔍𓆌</title>
        <style>
            body {
                font-family:
                    system-ui,
                    Segoe UI,
                    Roboto,
                    Arial;
                margin: 18px;
            }
            .meta {
                color: #555;
            }
            .bad {
                color: #a00;
                font-weight: 700;
            }
            .ok {
                color: #0a7a0a;
                font-weight: 700;
            }
            code {
                background: #f7f7f7;
                padding: 2px 4px;
                border-radius: 4px;
            }

            .table-wrap {
                width: 100%;
                overflow-x: auto;
                border: 1px solid #e6e6e6;
                border-radius: 6px;
            }

            table {
                width: 100%;
                border-collapse: collapse;
                min-width: 1200px;
            }

            th,
            td {
                border: 1px solid #eee;
                padding: 8px;
                text-align: left;
                vertical-align: top;
            }

            th {
                background: #f7f7f7;
                position: sticky;
                top: 0;
            }

            td.path {
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                max-width: 760px;
            }

            td.snip code {
                white-space: normal;
                word-break: break-word;
            }
        </style>
    </head>
    <body>
        <h2>𓆌🔍𓆌 BIAWAK LOOKING FOR 𓆌🔍𓆌</h2>

        <div class="meta">
            Directory: <b><?php echo h($start_dir); ?></b><br />
            Scanned: <b><?php echo h($total_scanned); ?></b> file(s) • Hits: <b><?php echo h(count($hits)); ?></b> • Max
            file size read: <b><?php echo h($MAX_FILE_SIZE); ?></b> bytes
        </div>
        <hr />

        <?php if (empty($hits)): ?>
        <p class="ok">✔ Biawak Aman.</p>
        <?php else: ?>
        <p class="bad">⚠ Oi Biawak Cek :</p>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th style="width: 60px">No</th>
                        <th style="width: 160px">Match</th>
                        <th style="width: 760px">File</th>
                        <th style="width: 110px">Size</th>
                        <th style="width: 180px">Modified</th>
                        <th>Snippet</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($hits as $i => $r): ?>
                    <tr>
                        <td><?php echo (int)($i+1); ?></td>
                        <td>
                            <code><?php echo h($r['match']); ?></code>
                        </td>
                        <td class="path" title="<?php echo h($r['path']); ?>"><?php echo h($r['path']); ?></td>
                        <td>
                            <?php echo h(number_format((int)$r['size'])); ?>
                            B
                        </td>
                        <td><?php echo h($r['mtime'] ? date('Y-m-d H:i:s', (int)$r['mtime']) : '-'); ?></td>
                        <td class="snip">
                            <code><?php echo h($r['snippet']); ?></code>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </body>
</html>