

<!DOCTYPE html>
<html lang="en-US" prefix="og: https://ogp.me/ns#">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="preload" as="style" href="https://fonts.googleapis.com/css?family=Open+Sans:100,200,300,400,500,600,700,800,900|Source+Sans+Pro:100,200,300,400,500,600,700,800,900|Poppins:100,200,300,400,500,600,700,800,900">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:100,200,300,400,500,600,700,800,900|Source+Sans+Pro:100,200,300,400,500,600,700,800,900|Poppins:100,200,300,400,500,600,700,800,900">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <title>Home - Travel Holiday Bali</title>
  <meta property="description" content="the perfect destination to find authentic and high-quality Bali souvenirs and keepsakes. Discover a wide selection of handcrafted items, traditional delicacies, and unique products that reflect the beauty and rich culture of the Island of the Gods. Shop with us for a memorable experience and unforgettable mementos from Bali!">
  <link rel="canonical" href="https://balitravel.store/" />
  <link rel='stylesheet' id='sbi_styles-css' href='https://balitravel.store/css/sbi-styles.min.css' media='all' />
  <link rel='stylesheet' id='wp-components-css' href='https://balitravel.store/css/style.min.css' media='all' />
  <link rel='stylesheet' id='wp-preferences-css' href='https://balitravel.store/css/style.min2.css' media='all' />
  <link rel='stylesheet' id='wp-block-editor-css' href='https://balitravel.store/css/style.min3.css' media='all' />
  <link rel='stylesheet' id='wp-reusable-blocks-css' href='https://balitravel.store/css/style.min4.css' media='all' />
  <link rel='stylesheet' id='wp-patterns-css' href='https://balitravel.store/css/style.min5.css' media='all' />
  <link rel='stylesheet' id='wp-editor-css' href='https://balitravel.store/css/style.min6.css' media='all' />
  <link rel='stylesheet' id='oxygen-css' href='https://balitravel.store/css/oxygen.css' media='all' />
  <link rel='stylesheet' id='megamenu-css' href='https://balitravel.store/css/style.css' media='all' />
  <link rel='stylesheet' id='dashicons-css' href='https://balitravel.store/css/dashicons.min.css' media='all' />
  <link rel='stylesheet' id='nta-css-popup-css' href='https://balitravel.store/css/style2.css' media='all' />
  <script src="https://balitravel.store/js/jquery.min.js" id="jquery-core-js"></script>
  <script src="https://balitravel.store/js/main.js" id="nta-js-popup-js"></script>
  <link rel="https://api.w.org/" href="https://www.travelholidaybali.com/wp-json/" />
  <link rel="alternate" title="JSON" type="application/json" href="https://www.travelholidaybali.com/wp-json/wp/v2/pages/81" />
  <link rel="EditURI" type="application/rsd+xml" title="RSD" href="https://www.travelholidaybali.com/xmlrpc.php?rsd" />
  
  <link rel="alternate" title="oEmbed (JSON)" type="application/json+oembed" href="https://www.travelholidaybali.com/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fwww.travelholidaybali.com%2F" />
  <link rel="alternate" title="oEmbed (XML)" type="text/xml+oembed" href="https://www.travelholidaybali.com/wp-json/oembed/1.0/embed?url=https%3A%2F%2Fwww.travelholidaybali.com%2F&#038;format=xml" />
  <!-- popup css -->
  <link rel="stylesheet" type="text/css" href="css/popup.css">

  <style class='wp-fonts-local'>
    @keyframes precise-glow {
      0% {
        /* Keadaan awal: glow lebih terang dari sebelumnya */
        box-shadow: 0 0 6px rgba(255, 80, 80, 0.8), 0 0 10px rgba(255, 80, 80, 0.6);
      }
      50% {
        /* Puncak animasi: glow dibuat lebih menyebar dan sangat terang */
        box-shadow: 0 0 14px 2px rgba(255, 100, 100, 1), 0 0 25px 5px rgba(255, 80, 80, 0.7);
      }
      100% {
        /* Kembali ke keadaan awal */
        box-shadow: 0 0 6px rgba(255, 80, 80, 0.8), 0 0 10px rgba(255, 80, 80, 0.6);
      }
    }

/* Atur div pembungkus utama */
#_header_right-118-13 {
  display: inline-block;
  vertical-align: middle;
  border-radius: 10px;
  animation: precise-glow 2.5s infinite ease-in-out;

  /* === TAMBAHKAN BARIS INI === */
  margin: 20px; /* Memberi jarak 10px dari semua sisi */
}

/* 3. Reset div internal (jaga-jaga) */
#_header_right-118-13 #shortcode-138-13,
#_header_right-118-13 .gtranslate_wrapper {
  display: block;
  padding: 0;
  margin: 0;
  line-height: 1;
}

/* 4. Style untuk dropdown <select> di dalamnya */
#_header_right-118-13 .gtranslate_wrapper select {
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;

  background-color: #ffffff;
  border: 1px solid #ccc;

  /* Pastikan radiusnya sama atau sedikit lebih kecil dari container */
  border-radius: 8px; 

  color: #333;
  padding: 8px 30px 8px 12px;
  font-size: 16px;
  cursor: pointer;
  margin: 0;

  /* Ikon panah kustom */
  background-image: url("data:image/svg+xml;charset=UTF8,%3Csvg%20xmlns='http://www.w3.org/2000/svg'%20viewBox='0%200%2024%2024'%20fill='%23555'%3E%3Cpath%20d='M7%2010l5%205%205-5z'/%3E%3C/svg%3E");
  background-repeat: no-repeat;
  background-position: right 8px center;
  background-size: 16px;
}

/* PASTIKAN BAGIAN INI ADA DI CSS ANDA */
@keyframes steam {
  0% {
    background-position: 0 0;
  }
  50% {
    background-position: 400% 0;
  }
  100% {
    background-position: 0 0;
  }
}

/* Atur div utama yang akan diberi class .glowing-frame */
.glowing-frame {
  position: relative;
  background-color: #1a1a1a;  
  border-radius: 15px;       
  padding: 10px;             
  margin: 10px;              
  z-index: 1;
}

/* Style untuk KEDUA lapisan (tajam dan blur) */
.glowing-frame::before,
.glowing-frame::after {
  content: '';
  position: absolute;
  left: -3px;
  top: -3px;
  width: calc(100% + 6px);
  height: calc(100% + 6px);
  z-index: -1;
  
  background: linear-gradient(45deg, #fb0000, rgb(255, 255, 255), rgb(73, 0, 0), rgb(194, 157, 34), rgb(255, 217, 0), #fb0000, rgb(255, 255, 255), rgb(73, 0, 0), rgb(194, 157, 34), rgb(255, 217, 0));
  background-size: 400%;
  
  /* Baris ini memanggil animasi "steam" */
  animation: steam 5s linear infinite;
  
  border-radius: inherit;
}

/* Tambahkan efek blur HANYA untuk lapisan ::after */
.glowing-frame::after {
  filter: blur(20px);
}

.slide-title {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  color: #fff;
  font-size: 3rem;
  font-weight: 700;
  text-align: center;
  text-shadow: 2px 2px 10px rgba(0,0,0,0.7);
  max-width: 90%;
}

.ct-span{
  font-size: 18px;
  color: green;
  font-weight: 500;
  text-decoration: none;
}


</style>
<link rel="icon" href="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" sizes="32x32" />
<link rel="icon" href="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" sizes="192x192" />
<link rel="apple-touch-icon" href="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" />
<meta name="msapplication-TileImage" content="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" />
<!-- potencial -->
<link rel='stylesheet' id='oxygen-cache-649-css' href='https://balitravel.store/css/649.css' media='all' />
<link rel='stylesheet' id='oxygen-cache-13-css' href='https://balitravel.store/css/13.css' media='all' />
<link rel='stylesheet' id='oxygen-cache-81-css' href='https://balitravel.store/css/81.css' media='all' />
<link rel='stylesheet' id='oxygen-universal-styles-css' href='https://balitravel.store/css/universal.css' media='all' />
<!-- END OF WP_HEAD() -->
</head>

<body class="home wp-singular page-template-default page page-id-81 wp-embed-responsive wp-theme-oxygen-is-not-a-theme  oxygen-body mega-menu-max-mega-menu-1 piotnetforms-edit">
  <header id="_header-114-13" style="position: static;"  class="oxy-header-wrapper oxy-sticky-header  oxy-header">
    <div id="_header_row-115-13" class="oxy-header-row">
      <div class="oxy-header-container">
        <div id="_header_left-116-13" class="oxy-header-left">
          <img style="border: 2px solid orange; border-radius: 50%;" id="image-160-13" alt="" src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" class="ct-image" srcset="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png 1000w, 768w" sizes="(max-width: 1000px) 100vw, 1000px" />
        </div>
        
        <div id="_header_center-117-13" class="oxy-header-center"></div>

        <!-- languages -->
        <div id="_header_right-118-13" class="oxy-header-right">
          <div id="shortcode-138-13" class="ct-shortcode">
            <div class="gtranslate_wrapper" style="font-size: 17px;" id="gt-wrapper-75268953"></div>
          </div>
        </div>
        <!-- end of language -->

      </div>
    </div>
  </header>
  
  <div id='inner_content-8-13' class='ct-inner-content'>
    <section id="section-23-81" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <link rel='stylesheet' id='oxygen-unslider-css' href='https://balitravel.store/css/unslider.css' type='text/css' media='all' />
        <style>
          #slide-1640-81 {
            background: url('https://res.cloudinary.com/dlzihbwqt/image/upload/v1758096206/niklas-weiss--2WlTWZLnRc-unsplash_qcnorm.jpg') center center / cover no-repeat;
            height: 600px; /* sesuaikan tinggi */
          }
          #slide-1649-81 {
            background: url('https://res.cloudinary.com/dlzihbwqt/image/upload/v1758096205/paolo-nicolello-zb3b08nJlww-unsplash_gy9qxj.jpg') center center / cover no-repeat;
            height: 600px;
          }
          #slide-1650-81 {
            background: url('https://res.cloudinary.com/dlzihbwqt/image/upload/v1758096205/alfiano-sutianto-exFdOWkYBQw-unsplash_vmuomw.jpg') center center / cover no-repeat;
            height: 600px;
          }
          #slide-1639-81 {
            background: url('https://res.cloudinary.com/dlzihbwqt/image/upload/v1758096204/cassie-gallegos-i-VetqrMmNY-unsplash_aggg9m.jpg') center center / cover no-repeat;
            height: 600px;
          }
          #slide-1642-81 {
            background: url('https://res.cloudinary.com/dlzihbwqt/image/upload/v1758096204/harry-kessell-eE2trMn-6a0-unsplash_pzt2ho.jpg') center center / cover no-repeat;
            height: 600px;
          }
        </style>

        <div id="slider-1553-81" class="ct-slider ct_unique_slider_141">
          <div class="oxygen-unslider-container">
            <ul>
              <li>
                <div id="slide-1640-81" class="ct-slide">
                  <h1 class="slide-title">Discover the Magic of Bali – Paradise Awaits</h1>
                </div>
              </li>
              <li>
                <div id="slide-1649-81" class="ct-slide">
                  <h1 class="slide-title">Experience Bali’s Hidden Treasures in Every Corner</h1>
                </div>
              </li>
              <li>
                <div id="slide-1650-81" class="ct-slide">
                  <h1 class="slide-title">Bali – Where Culture Meets Natural Beauty</h1>
                </div>
              </li>
              <li>
                <div id="slide-1639-81" class="ct-slide">
                  <h1 class="slide-title">Feel the Spirit of Bali’s Timeless Paradise</h1>
                </div>
              </li>
              <li>
                <div id="slide-1642-81" class="ct-slide">
                  <h1 class="slide-title">Unwind, Explore, and Fall in Love with Bali</h1>
                </div>
              </li>
            </ul>
          </div>
        </div>
        <script class="ct-slider-script">
          jQuery(document).ready(function($) {
            $('#slider-1553-81.ct_unique_slider_141 .oxygen-unslider-container:not(.unslider-horizontal,.unslider-fade)').unslider({
              autoplay: true,
              delay: 5000,
              animation: 'fade',
              speed: 1500,
              arrows: true,
              nav: true,
              infinite: false
            })
          });
        </script>
      </div>
    </section>
    <section id="section-50-81" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <div id="div_block-1433-81" class="ct-div-block">
          <div id="div_block-1434-81" class="ct-div-block">
            <div id="text_block-1436-81" class="ct-text-block">About Us <br>
            </div>
            <div id="text_block-1437-81" class="ct-text-block">We Will Helping You Find Your Dream Vacation <br>
            </div>
            <div id="text_block-1439-81" class="ct-text-block">
              <font style="vertical-align: inherit;">
                <font style="vertical-align: inherit;"></font>Travel around Bali in a comfortable car with your private driver. We will happily show you the best places to visit and take you for unique cultural experiences during your holiday on the Island of the Gods. <font style="vertical-align: inherit;" class=""></font>
              </font>
              <br>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section id="section-247-280" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <div id="tour" class="ct-div-block">
          <div id="div_block-1748-649" class="ct-div-block">
            <div id="text_block-1751-649" class="ct-text-block">Tours</div>
            <div id="text_block-1752-649" class="ct-text-block">Popular Tours For You</div>
          </div>
          <div id="div_block-1749-649" class="ct-div-block">
            <div id="text_block-1753-649" class="ct-text-block">Bali, the Island of the Gods which located in the central part of Indonesia. The enchantment of Bali always makes anyone interested in exploring every corner.</div>
          </div>
        </div>
      </div>
    </section>
    <section id="section-1879-649" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <div id="div_block-1880-649" class="ct-div-block">
          <div id="text_block-1881-649" class="ct-text-block">Packages</div>
          <div id="_dynamic_list-248-280" class="oxy-dynamic-list">

                          <div id="div_block-249-280-0" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-0" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-0"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1757769331/photo_2025-09-13_20-15-14_e3colb.jpg"
                  alt="PAKET 1"
                  style="cursor:pointer"
                  onclick="openModal(0)">
                </div>
                <div id="div_block-254-280-0" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-0" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-0" class="ct-span" data-id="span-485-280">
                      PAKET 1                    </span>
                                          <span id="span-853-280-0" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-0" class="modal" data-id="modal-0">
                <div class="modal-content" data-id="modal-content-0">
                  <span id="close-0" class="close" data-id="close-0" onclick="closeModal(0)">&times;</span>
                  <h2 id="modal-title-0" data-id="modal-title-0">PAKET 1</h2>
                  <div id="modal-desc-0" class="ct-text-block" data-id="modal-desc-0">
                    
    <ul>
    <b>Destination Trip : rikuwes pilihan paket</b>
    <li>Pick up time at the hotel at 08.30am</li>
    <li>Tukad Cepung Waterfall</li>
    <li>Tirta Gangga Water Palace</li>
    <li>Luwak Coffee Plantation</li>
    <li>Gate of Heaven at Lempunyang Temple</li>
    <li>Finish the tour and drop back to the hotel</li>
    </ul>
    <ul>
    <b>Inclusion :</b>
    <li>Private car with English speaking driver</li>
    <li>Petrol</li>
    <li>Parking fee</li>
    <li>Mineral water</li>
    </ul>
    <ul>
    <b>Exclude :</b>
    <li>Entrance fees</li>
    <li>Lunch</li>
    </ul>                  </div>
                </div>
              </div>
                          <div id="div_block-249-280-1" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-1" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-1"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759343781/Gray_Minimalist_Home_For_Sale_Facebook_Post_2_zuuwbl.png"
                  alt="PAKET 2"
                  style="cursor:pointer"
                  onclick="openModal(1)">
                </div>
                <div id="div_block-254-280-1" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-1" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-1" class="ct-span" data-id="span-485-280">
                      PAKET 2                    </span>
                                          <span id="span-853-280-1" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-1" class="modal" data-id="modal-1">
                <div class="modal-content" data-id="modal-content-1">
                  <span id="close-1" class="close" data-id="close-1" onclick="closeModal(1)">&times;</span>
                  <h2 id="modal-title-1" data-id="modal-title-1">PAKET 2</h2>
                  <div id="modal-desc-1" class="ct-text-block" data-id="modal-desc-1">
                     
    West Bali Tour Package #1 mengajak Anda menjelajahi pesona Bali bagian barat. Perjalanan dimulai dari Taman Ayun Temple, pura indah yang dikelilingi taman hijau nan asri. Selanjutnya, Anda akan menikmati pengalaman unik mencicipi kopi khas Bali di Luwak Coffee Plantation. Sebagai penutup, nikmati panorama matahari terbenam yang memukau di Tanah Lot Temple, salah satu ikon wisata Bali yang terkenal di dunia.                  </div>
                </div>
              </div>
                          <div id="div_block-249-280-2" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-2" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-2"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759343781/Gray_Minimalist_Home_For_Sale_Facebook_Post_3_ydmszc.png"
                  alt="PAKET 3"
                  style="cursor:pointer"
                  onclick="openModal(2)">
                </div>
                <div id="div_block-254-280-2" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-2" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-2" class="ct-span" data-id="span-485-280">
                      PAKET 3                    </span>
                                          <span id="span-853-280-2" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-2" class="modal" data-id="modal-2">
                <div class="modal-content" data-id="modal-content-2">
                  <span id="close-2" class="close" data-id="close-2" onclick="closeModal(2)">&times;</span>
                  <h2 id="modal-title-2" data-id="modal-title-2">PAKET 3</h2>
                  <div id="modal-desc-2" class="ct-text-block" data-id="modal-desc-2">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-3" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-3" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-3"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759343781/Gray_Minimalist_Home_For_Sale_Facebook_Post_4_zpjoip.png"
                  alt="PAKET 4"
                  style="cursor:pointer"
                  onclick="openModal(3)">
                </div>
                <div id="div_block-254-280-3" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-3" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-3" class="ct-span" data-id="span-485-280">
                      PAKET 4                    </span>
                                          <span id="span-853-280-3" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-3" class="modal" data-id="modal-3">
                <div class="modal-content" data-id="modal-content-3">
                  <span id="close-3" class="close" data-id="close-3" onclick="closeModal(3)">&times;</span>
                  <h2 id="modal-title-3" data-id="modal-title-3">PAKET 4</h2>
                  <div id="modal-desc-3" class="ct-text-block" data-id="modal-desc-3">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-4" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-4" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-4"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759343786/Gray_Minimalist_Home_For_Sale_Facebook_Post_mgafjq.png"
                  alt="PAKET 5"
                  style="cursor:pointer"
                  onclick="openModal(4)">
                </div>
                <div id="div_block-254-280-4" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-4" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-4" class="ct-span" data-id="span-485-280">
                      PAKET 5                    </span>
                                          <span id="span-853-280-4" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-4" class="modal" data-id="modal-4">
                <div class="modal-content" data-id="modal-content-4">
                  <span id="close-4" class="close" data-id="close-4" onclick="closeModal(4)">&times;</span>
                  <h2 id="modal-title-4" data-id="modal-title-4">PAKET 5</h2>
                  <div id="modal-desc-4" class="ct-text-block" data-id="modal-desc-4">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-5" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-5" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-5"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759343788/Gray_Minimalist_Home_For_Sale_Facebook_Post_rryi7z.png"
                  alt="PAKET 6"
                  style="cursor:pointer"
                  onclick="openModal(5)">
                </div>
                <div id="div_block-254-280-5" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-5" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-5" class="ct-span" data-id="span-485-280">
                      PAKET 6                    </span>
                                          <span id="span-853-280-5" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-5" class="modal" data-id="modal-5">
                <div class="modal-content" data-id="modal-content-5">
                  <span id="close-5" class="close" data-id="close-5" onclick="closeModal(5)">&times;</span>
                  <h2 id="modal-title-5" data-id="modal-title-5">PAKET 6</h2>
                  <div id="modal-desc-5" class="ct-text-block" data-id="modal-desc-5">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-6" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-6" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-6"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346157/Gray_Minimalist_Home_For_Sale_Facebook_Post_1_b4uc5i.png"
                  alt="PAKET 7"
                  style="cursor:pointer"
                  onclick="openModal(6)">
                </div>
                <div id="div_block-254-280-6" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-6" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-6" class="ct-span" data-id="span-485-280">
                      PAKET 7                    </span>
                                          <span id="span-853-280-6" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-6" class="modal" data-id="modal-6">
                <div class="modal-content" data-id="modal-content-6">
                  <span id="close-6" class="close" data-id="close-6" onclick="closeModal(6)">&times;</span>
                  <h2 id="modal-title-6" data-id="modal-title-6">PAKET 7</h2>
                  <div id="modal-desc-6" class="ct-text-block" data-id="modal-desc-6">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-7" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-7" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-7"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346158/Gray_Minimalist_Home_For_Sale_Facebook_Post_2_kxe4pg.png"
                  alt="PAKET 8"
                  style="cursor:pointer"
                  onclick="openModal(7)">
                </div>
                <div id="div_block-254-280-7" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-7" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-7" class="ct-span" data-id="span-485-280">
                      PAKET 8                    </span>
                                          <span id="span-853-280-7" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-7" class="modal" data-id="modal-7">
                <div class="modal-content" data-id="modal-content-7">
                  <span id="close-7" class="close" data-id="close-7" onclick="closeModal(7)">&times;</span>
                  <h2 id="modal-title-7" data-id="modal-title-7">PAKET 8</h2>
                  <div id="modal-desc-7" class="ct-text-block" data-id="modal-desc-7">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-8" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-8" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-8"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346257/Gray_Minimalist_Home_For_Sale_Facebook_Post_3_sgcwho.png"
                  alt="PAKET 9"
                  style="cursor:pointer"
                  onclick="openModal(8)">
                </div>
                <div id="div_block-254-280-8" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-8" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-8" class="ct-span" data-id="span-485-280">
                      PAKET 9                    </span>
                                          <span id="span-853-280-8" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-8" class="modal" data-id="modal-8">
                <div class="modal-content" data-id="modal-content-8">
                  <span id="close-8" class="close" data-id="close-8" onclick="closeModal(8)">&times;</span>
                  <h2 id="modal-title-8" data-id="modal-title-8">PAKET 9</h2>
                  <div id="modal-desc-8" class="ct-text-block" data-id="modal-desc-8">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-9" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-9" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-9"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346257/Gray_Minimalist_Home_For_Sale_Facebook_Post_4_gknzfv.png"
                  alt="PAKET 10"
                  style="cursor:pointer"
                  onclick="openModal(9)">
                </div>
                <div id="div_block-254-280-9" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-9" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-9" class="ct-span" data-id="span-485-280">
                      PAKET 10                    </span>
                                          <span id="span-853-280-9" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-9" class="modal" data-id="modal-9">
                <div class="modal-content" data-id="modal-content-9">
                  <span id="close-9" class="close" data-id="close-9" onclick="closeModal(9)">&times;</span>
                  <h2 id="modal-title-9" data-id="modal-title-9">PAKET 10</h2>
                  <div id="modal-desc-9" class="ct-text-block" data-id="modal-desc-9">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-10" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-10" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-10"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346340/Gray_Minimalist_Home_For_Sale_Facebook_Post_2_ef9lgy.png"
                  alt="PAKET 11"
                  style="cursor:pointer"
                  onclick="openModal(10)">
                </div>
                <div id="div_block-254-280-10" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-10" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-10" class="ct-span" data-id="span-485-280">
                      PAKET 11                    </span>
                                          <span id="span-853-280-10" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-10" class="modal" data-id="modal-10">
                <div class="modal-content" data-id="modal-content-10">
                  <span id="close-10" class="close" data-id="close-10" onclick="closeModal(10)">&times;</span>
                  <h2 id="modal-title-10" data-id="modal-title-10">PAKET 11</h2>
                  <div id="modal-desc-10" class="ct-text-block" data-id="modal-desc-10">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-11" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-11" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-11"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346487/Gray_Minimalist_Home_For_Sale_Facebook_Post_1_vj7k7k.png"
                  alt="PAKET 12"
                  style="cursor:pointer"
                  onclick="openModal(11)">
                </div>
                <div id="div_block-254-280-11" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-11" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-11" class="ct-span" data-id="span-485-280">
                      PAKET 12                    </span>
                                          <span id="span-853-280-11" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-11" class="modal" data-id="modal-11">
                <div class="modal-content" data-id="modal-content-11">
                  <span id="close-11" class="close" data-id="close-11" onclick="closeModal(11)">&times;</span>
                  <h2 id="modal-title-11" data-id="modal-title-11">PAKET 12</h2>
                  <div id="modal-desc-11" class="ct-text-block" data-id="modal-desc-11">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-12" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-12" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-12"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346487/Gray_Minimalist_Home_For_Sale_Facebook_Post_2_qhec4n.png"
                  alt="PAKET 13"
                  style="cursor:pointer"
                  onclick="openModal(12)">
                </div>
                <div id="div_block-254-280-12" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-12" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-12" class="ct-span" data-id="span-485-280">
                      PAKET 13                    </span>
                                          <span id="span-853-280-12" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-12" class="modal" data-id="modal-12">
                <div class="modal-content" data-id="modal-content-12">
                  <span id="close-12" class="close" data-id="close-12" onclick="closeModal(12)">&times;</span>
                  <h2 id="modal-title-12" data-id="modal-title-12">PAKET 13</h2>
                  <div id="modal-desc-12" class="ct-text-block" data-id="modal-desc-12">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-13" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-13" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-13"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346547/Gray_Minimalist_Home_For_Sale_Facebook_Post_2_qmj85j.png"
                  alt="PAKET 14"
                  style="cursor:pointer"
                  onclick="openModal(13)">
                </div>
                <div id="div_block-254-280-13" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-13" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-13" class="ct-span" data-id="span-485-280">
                      PAKET 14                    </span>
                                          <span id="span-853-280-13" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-13" class="modal" data-id="modal-13">
                <div class="modal-content" data-id="modal-content-13">
                  <span id="close-13" class="close" data-id="close-13" onclick="closeModal(13)">&times;</span>
                  <h2 id="modal-title-13" data-id="modal-title-13">PAKET 14</h2>
                  <div id="modal-desc-13" class="ct-text-block" data-id="modal-desc-13">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-14" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-14" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-14"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759346547/Gray_Minimalist_Home_For_Sale_Facebook_Post_3_cfmume.png"
                  alt="PAKET 15"
                  style="cursor:pointer"
                  onclick="openModal(14)">
                </div>
                <div id="div_block-254-280-14" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-14" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-14" class="ct-span" data-id="span-485-280">
                      PAKET 15                    </span>
                                          <span id="span-853-280-14" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-14" class="modal" data-id="modal-14">
                <div class="modal-content" data-id="modal-content-14">
                  <span id="close-14" class="close" data-id="close-14" onclick="closeModal(14)">&times;</span>
                  <h2 id="modal-title-14" data-id="modal-title-14">PAKET 15</h2>
                  <div id="modal-desc-14" class="ct-text-block" data-id="modal-desc-14">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-15" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-15" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-15"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759396566/Gray_Minimalist_Home_For_Sale_Facebook_Post_cjo4ja.png"
                  alt="PAKET 16"
                  style="cursor:pointer"
                  onclick="openModal(15)">
                </div>
                <div id="div_block-254-280-15" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-15" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-15" class="ct-span" data-id="span-485-280">
                      PAKET 16                    </span>
                                          <span id="span-853-280-15" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-15" class="modal" data-id="modal-15">
                <div class="modal-content" data-id="modal-content-15">
                  <span id="close-15" class="close" data-id="close-15" onclick="closeModal(15)">&times;</span>
                  <h2 id="modal-title-15" data-id="modal-title-15">PAKET 16</h2>
                  <div id="modal-desc-15" class="ct-text-block" data-id="modal-desc-15">
                                      </div>
                </div>
              </div>
                          <div id="div_block-249-280-16" class="ct-div-block paket-item" data-id="div_block-249-280">
                <div id="div_block-250-280-16" class="ct-div-block" data-id="div_block-250-280">
                  <!-- Klik gambar → buka popup -->
                  <img id="image-250-280-16"
                  class="ct-image"
                  data-id="image-250-280"
                  src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1759396566/Gray_Minimalist_Home_For_Sale_Facebook_Post_l3xcro.png"
                  alt="PAKET 17"
                  style="cursor:pointer"
                  onclick="openModal(16)">
                </div>
                <div id="div_block-254-280-16" class="ct-div-block" data-id="div_block-254-280">
                  <a id="text_block-470-280-16" class="ct-link-text" href="https://wa.me/6283869040634">
                    <span id="span-485-280-16" class="ct-span" data-id="span-485-280">
                      PAKET 17                    </span>
                                          <span id="span-853-280-16" class="ct-span" data-id="span-853-280">
                        Contact Admin <i class="fa fa-whatsapp"></i>
                      </span>
                                      </a>
                </div>
              </div>

              <!-- Popup modal -->
              <div id="modal-16" class="modal" data-id="modal-16">
                <div class="modal-content" data-id="modal-content-16">
                  <span id="close-16" class="close" data-id="close-16" onclick="closeModal(16)">&times;</span>
                  <h2 id="modal-title-16" data-id="modal-title-16">PAKET 17</h2>
                  <div id="modal-desc-16" class="ct-text-block" data-id="modal-desc-16">
                                      </div>
                </div>
              </div>
            
          </div> <!-- oxy-dynamic-list -->
        </div>
      </div>
    </section>
    <section id="section-1488-81" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <div id="div_block-1515-81" class="ct-div-block">
          <div id="text_block-1517-81" class="ct-text-block">Our Process <br>
          </div>
          <div id="text_block-1518-81" class="ct-text-block">We Complete Every Step Carefully <br>
          </div>
          <div id="text_block-1519-81" class="ct-text-block">Book your tour now <br>
          </div>
        </div>
        <div id="div_block-1496-81" class="ct-div-block">
          <div id="div_block-1497-81" class="ct-div-block">
            <div id="fancy_icon-1498-81" class="ct-fancy-icon">
              <svg id="svg-fancy_icon-1498-81">
                <use xlink:href="#FontAwesomeicon-book"></use>
              </svg>
            </div>
            <div id="text_block-1499-81" class="ct-text-block">1. Book A Tour <br>
            </div>
            <div id="text_block-1500-81" class="ct-text-block">Choose the tour package you want <br>
            </div>
          </div>
          <div id="div_block-1501-81" class="ct-div-block">
            <div id="fancy_icon-1502-81" class="ct-fancy-icon">
              <svg id="svg-fancy_icon-1502-81">
                <use xlink:href="#FontAwesomeicon-check-square-o"></use>
              </svg>
            </div>
            <div id="text_block-1503-81" class="ct-text-block">2. Confirmation <br>
            </div>
            <div id="text_block-1504-81" class="ct-text-block">Confirm all tour orders that you have ordered <br>
            </div>
          </div>
          <div id="div_block-1522-81" class="ct-div-block">
            <div id="fancy_icon-1523-81" class="ct-fancy-icon">
              <svg id="svg-fancy_icon-1523-81">
                <use xlink:href="#FontAwesomeicon-tripadvisor"></use>
              </svg>
            </div>
            <div id="text_block-1524-81" class="ct-text-block">3. Enjoy Your Trip <br>
            </div>
            <div id="text_block-1525-81" class="ct-text-block">Enjoy the tour that you have chosen, and happy holiday <br>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section id="section-216-81" class=" ct-section">
      <div class="ct-section-inner-wrap">
        <div id="div_block-217-81" class="ct-div-block">
          <div id="shortcode-218-81" class="ct-shortcode">
            <div id="sb_instagram" class="sbi sbi_mob_col_3 sbi_tab_col_3 sbi_col_3 sbi_width_resp" style="padding-bottom: 10px;" data-feedid="*1" data-res="auto" data-cols="3" data-colsmobile="3" data-colstablet="3" data-num="6" data-nummobile="6" data-item-padding="5" data-shortcode-atts="{&quot;feed&quot;:&quot;1&quot;}" data-postid="81" data-locatornonce="17b3826eb7" data-imageaspectratio="1:1" data-sbi-flags="favorLocal">
              <div class="sb_instagram_header  sbi_medium">
                <a class="sbi_header_link" target="_blank" rel="nofollow noopener" href="https://www.instagram.com/">
                  <div class="sbi_header_text sbi_no_bio">
                    <div class="sbi_header_img">
                      <div class="sbi_header_img_hover">
                        <svg class="sbi_new_logo fa-instagram fa-w-14" aria-hidden="true" data-fa-processed="" aria-label="Instagram" data-prefix="fab" data-icon="instagram" role="img" viewBox="0 0 448 512">
                          <path fill="currentColor" d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>
                        </svg>
                      </div>
                      <img style="border: 5px solid orange; border-radius: 50%;" src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png" alt="" width="50" height="50">
                    </div>
                    <div style="border: 5px solid orange; padding: 10px; bor" class="sbi_feedtheme_header_text oxy-header-center" id="_header_right-118-13">
                      <marquee>
                        <h3>Balitravel.store : the perfect destination to find authentic and high-quality Bali souvenirs and keepsakes. Discover a wide selection of handcrafted items, traditional delicacies, and unique products that reflect the beauty and rich culture of the Island of the Gods. Shop with us for a memorable experience and unforgettable mementos from Bali!</h3>
                      </marquee>
                    </div>
                  </div>
                </a>
              </div>
              <div id="sbi_images" style="gap: 10px;">

                                  <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_1"
                  data-date="1681938451">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328276/photo_17_2025-09-20_07-29-15_rlqkyn.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_2"
                  data-date="1681911772">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328275/photo_12_2025-09-20_07-29-15_i3gai3.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_3"
                  data-date="1681859560">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328274/photo_4_2025-09-20_07-29-15_il16x5.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_4"
                  data-date="1681770772">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328275/photo_16_2025-09-20_07-29-15_suvifk.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_5"
                  data-date="1681770329">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328274/photo_5_2025-09-20_07-29-15_mvtcrj.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_6"
                  data-date="1681663453">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328274/photo_10_2025-09-20_07-29-15_wimmya.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_7"
                  data-date="1681663453">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328276/photo_20_2025-09-20_07-29-15_zr5pem.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_8"
                  data-date="1681663453">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328276/photo_20_2025-09-20_07-29-15_zr5pem.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
                                <div class="sbi_item sbi_type_image sbi_new sbi_transition"
                  id="PHOTO_9"
                  data-date="1681663453">
                  <div class="sbi_photo_wrap">
                    <a class="sbi_photo" href="###" target="_blank">
                      <img src="https://res.cloudinary.com/dlzihbwqt/image/upload/v1758328276/photo_20_2025-09-20_07-29-15_zr5pem.jpg" alt="Gallery Photo">
                    </a>
                  </div>
                </div>
              
            </div> <!--End OF sbi_images -->
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<section id="section-132-13" class=" ct-section">
  <div class="ct-section-inner-wrap">
    <div id="div_block-134-13" class="ct-div-block">
      <div id="text_block-135-13" class="ct-text-block">Still have more questions? <br>
      </div>
      <div id="text_block-136-13" class="ct-text-block">Please contact us for more information about our services <br>
      </div>
      <div id="div_block-140-13" class="ct-div-block">
        <div id="shortcode-139-13" class="ct-shortcode">
          <div id="nta-wabutton-626" style="margin: 30px 0 30px;">
            <a target="_blank" href="https://web.whatsapp.com/send?phone=6283869040634&text=Hello Admin, i want a tour *Home - Travel Holiday Bali*, Can you help me? Link : https://balitravel.store/" class="wa__button wa__sq_button wa__stt_online wa__btn_w_img ">
              <div class="wa__cs_img">
                <div class="wa__cs_img_wrap" style="background: url(https://res.cloudinary.com/dlzihbwqt/image/upload/v1758085309/logo-circle-transparan_fvujpr.png) center center no-repeat; background-size: cover;"></div>
              </div>
              <div class="wa__btn_txt">
                <div class="wa__cs_info">
                  <div class="wa__cs_name">Admin</div>
                  <div class="wa__cs_status">Online</div>
                </div>
                <div class="wa__btn_title">Reservation</div>
              </div>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section id="section-9-13" class=" ct-section">
  <div class="ct-section-inner-wrap">
    <div id="div_block-42-13" class="ct-div-block">
      <div id="div_block-11-13" class="ct-div-block">
        <div id="_rich_text-111-13" class="oxy-rich-text">
          <p>You will be treated like family. Your safety and enjoyment is our primary mission. We are excited to meet you!.</p>
        </div>
      </div>
      <div id="div_block-100-13" class="ct-div-block">
        <h3 id="headline-101-13" class="ct-headline hyperion-heading-three">Contact info</h3>
        <div id="div_block-143-13" class="ct-div-block">
          <div id="fancy_icon-144-13" class="ct-fancy-icon">
            <svg id="svg-fancy_icon-144-13">
              <use xlink:href="#FontAwesomeicon-phone-square"></use>
            </svg>
          </div>
          <div id="text_block-145-13" class="ct-text-block"><a href="tel:+6283869040634">083869040634</a></div>
        </div>
        <div id="div_block-146-13" class="ct-div-block">
          <div id="fancy_icon-147-13" class="ct-fancy-icon">
            <svg id="svg-fancy_icon-147-13">
              <use xlink:href="#FontAwesomeicon-whatsapp"></use>
            </svg>
          </div>
          <div id="text_block-148-13" class="ct-text-block"><a href="https://wa.me/6283869040634">+6283869040634</a></div>
        </div>
        <div id="div_block-149-13" class="ct-div-block">
          <div id="fancy_icon-150-13" class="ct-fancy-icon">
            <svg id="svg-fancy_icon-150-13">
              <use xlink:href="#FontAwesomeicon-envelope-o"></use>
            </svg>
          </div>
          <div id="text_block-151-13" class="ct-text-block"><a href="/cdn-cgi/l/email-protection#c3a7b1aab5a6b1a1a2afaaf0f483a4aea2aaafeda0acae"><span class="__cf_email__" data-cfemail="5236203b24372030333e3b616512353f333b3e7c313d3f">[email&#160;protected]</span></a></div>
        </div>
        <div id="div_block-152-13" class="ct-div-block">
          <div id="fancy_icon-153-13" class="ct-fancy-icon">
            <svg id="svg-fancy_icon-153-13">
              <use xlink:href="#FontAwesomeicon-map-marker"></use>
            </svg>
          </div>
          <div id="text_block-154-13" class="ct-text-block">Jl. Bypass Ngurah Rai Gg. Patasari, Kuta, Kec. Kuta, Kabupaten Badung, Bali 80361</div>
        </div>
      </div>
      <div id="div_block-157-13" class="ct-div-block">
        <h3 id="headline-158-13" class="ct-headline hyperion-heading-three">Information</h3>
        <div id="_social_icons-142-13" class="oxy-social-icons">

          <a href="https://www.facebook.com/profile.php?id=61581123686784" target='_blank' class='oxy-social-icons-facebook'>
            <svg>
              <title>Visit our Facebook</title>
              <use xlink:href='#oxy-social-icons-icon-facebook-blank'></use>
            </svg>
          </a>
          <a href="https://www.instagram.com/bali_sun_day?igsh=MWJ4ZWZzOW1hcWx0MA==" target='_blank' class='oxy-social-icons-instagram'>
            <svg>
              <title>Visit our Instagram</title>
              <use xlink:href='#oxy-social-icons-icon-instagram-blank'></use>
            </svg>
          </a>

          <a href="https://www.youtube.com/@dargombesmusik" target='_blank' class='oxy-social-icons-icon-youtube'>
            <svg>
              <title>Visit our Youtube</title>
              <use xlink:href='#oxy-social-icons-icon-youtube-blank'></use>
            </svg>
          </a>

          <a href="##" target='_blank' class='oxy-social-icons-icon-twitter'>
            <svg>
              <title>Visit our Twitter</title>
              <use xlink:href='#oxy-social-icons-icon-twitter-blank'></use>
            </svg>
          </a>



        </div>
      </div>
    </div>
    <div id="div_block-125-13" class="ct-div-block">
      <div id="_rich_text-131-13" class="oxy-rich-text">
        <p>© Copyright balitravel.store. All Rights Reserved.</a>
        </p>
      </div>
    </div>
  </div>
</section>

<!-- WP_FOOTER -->

<div class="wa__popup_chat_box">
  <div class="wa__popup_heading">
    <div class="wa__popup_title">Start a Conversation</div>
    <div class="wa__popup_intro">Hi! Click one of our member below to chat on <strong>Whatsapp</strong>
    </a>
  </div>
</div>

<!-- /.wa__popup_chat_box -->
<svg style="position: absolute; width: 0; height: 0; overflow: hidden;" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <defs>

    <symbol id="oxy-social-icons-icon-facebook" viewBox="0 0 32 32">
      <title>facebook</title>
      <path d="M19 6h5v-6h-5c-3.86 0-7 3.14-7 7v3h-4v6h4v16h6v-16h5l1-6h-6v-3c0-0.542 0.458-1 1-1z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-youtube" viewBox="0 0 32 32">
      <title>youtube</title>
      <path d="M31.681 9.6c0 0-0.313-2.206-1.275-3.175-1.219-1.275-2.581-1.281-3.206-1.356-4.475-0.325-11.194-0.325-11.194-0.325h-0.012c0 0-6.719 0-11.194 0.325-0.625 0.075-1.987 0.081-3.206 1.356-0.963 0.969-1.269 3.175-1.269 3.175s-0.319 2.588-0.319 5.181v2.425c0 2.587 0.319 5.181 0.319 5.181s0.313 2.206 1.269 3.175c1.219 1.275 2.819 1.231 3.531 1.369 2.563 0.244 10.881 0.319 10.881 0.319s6.725-0.012 11.2-0.331c0.625-0.075 1.988-0.081 3.206-1.356 0.962-0.969 1.275-3.175 1.275-3.175s0.319-2.587 0.319-5.181v-2.425c-0.006-2.588-0.325-5.181-0.325-5.181zM12.694 20.15v-8.994l8.644 4.513-8.644 4.481z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-twitter" viewBox="0 0 32 32">
      <title>twitter</title>
      <path d="M32 7.075c-1.175 0.525-2.444 0.875-3.769 1.031 1.356-0.813 2.394-2.1 2.887-3.631-1.269 0.75-2.675 1.3-4.169 1.594-1.2-1.275-2.906-2.069-4.794-2.069-3.625 0-6.563 2.938-6.563 6.563 0 0.512 0.056 1.012 0.169 1.494-5.456-0.275-10.294-2.888-13.531-6.862-0.563 0.969-0.887 2.1-0.887 3.3 0 2.275 1.156 4.287 2.919 5.463-1.075-0.031-2.087-0.331-2.975-0.819 0 0.025 0 0.056 0 0.081 0 3.181 2.263 5.838 5.269 6.437-0.55 0.15-1.131 0.231-1.731 0.231-0.425 0-0.831-0.044-1.237-0.119 0.838 2.606 3.263 4.506 6.131 4.563-2.25 1.762-5.075 2.813-8.156 2.813-0.531 0-1.050-0.031-1.569-0.094 2.913 1.869 6.362 2.95 10.069 2.95 12.075 0 18.681-10.006 18.681-18.681 0-0.287-0.006-0.569-0.019-0.85 1.281-0.919 2.394-2.075 3.275-3.394z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-instagram" viewBox="0 0 32 32">
      <title>instagram</title>
      <path d="M16 2.881c4.275 0 4.781 0.019 6.462 0.094 1.563 0.069 2.406 0.331 2.969 0.55 0.744 0.288 1.281 0.638 1.837 1.194 0.563 0.563 0.906 1.094 1.2 1.838 0.219 0.563 0.481 1.412 0.55 2.969 0.075 1.688 0.094 2.194 0.094 6.463s-0.019 4.781-0.094 6.463c-0.069 1.563-0.331 2.406-0.55 2.969-0.288 0.744-0.637 1.281-1.194 1.837-0.563 0.563-1.094 0.906-1.837 1.2-0.563 0.219-1.413 0.481-2.969 0.55-1.688 0.075-2.194 0.094-6.463 0.094s-4.781-0.019-6.463-0.094c-1.563-0.069-2.406-0.331-2.969-0.55-0.744-0.288-1.281-0.637-1.838-1.194-0.563-0.563-0.906-1.094-1.2-1.837-0.219-0.563-0.481-1.413-0.55-2.969-0.075-1.688-0.094-2.194-0.094-6.463s0.019-4.781 0.094-6.463c0.069-1.563 0.331-2.406 0.55-2.969 0.288-0.744 0.638-1.281 1.194-1.838 0.563-0.563 1.094-0.906 1.838-1.2 0.563-0.219 1.412-0.481 2.969-0.55 1.681-0.075 2.188-0.094 6.463-0.094zM16 0c-4.344 0-4.887 0.019-6.594 0.094-1.7 0.075-2.869 0.35-3.881 0.744-1.056 0.412-1.95 0.956-2.837 1.85-0.894 0.888-1.438 1.781-1.85 2.831-0.394 1.019-0.669 2.181-0.744 3.881-0.075 1.713-0.094 2.256-0.094 6.6s0.019 4.887 0.094 6.594c0.075 1.7 0.35 2.869 0.744 3.881 0.413 1.056 0.956 1.95 1.85 2.837 0.887 0.887 1.781 1.438 2.831 1.844 1.019 0.394 2.181 0.669 3.881 0.744 1.706 0.075 2.25 0.094 6.594 0.094s4.888-0.019 6.594-0.094c1.7-0.075 2.869-0.35 3.881-0.744 1.050-0.406 1.944-0.956 2.831-1.844s1.438-1.781 1.844-2.831c0.394-1.019 0.669-2.181 0.744-3.881 0.075-1.706 0.094-2.25 0.094-6.594s-0.019-4.887-0.094-6.594c-0.075-1.7-0.35-2.869-0.744-3.881-0.394-1.063-0.938-1.956-1.831-2.844-0.887-0.887-1.781-1.438-2.831-1.844-1.019-0.394-2.181-0.669-3.881-0.744-1.712-0.081-2.256-0.1-6.6-0.1v0z"></path>
      <path d="M16 7.781c-4.537 0-8.219 3.681-8.219 8.219s3.681 8.219 8.219 8.219 8.219-3.681 8.219-8.219c0-4.537-3.681-8.219-8.219-8.219zM16 21.331c-2.944 0-5.331-2.387-5.331-5.331s2.387-5.331 5.331-5.331c2.944 0 5.331 2.387 5.331 5.331s-2.387 5.331-5.331 5.331z"></path>
      <path d="M26.462 7.456c0 1.060-0.859 1.919-1.919 1.919s-1.919-0.859-1.919-1.919c0-1.060 0.859-1.919 1.919-1.919s1.919 0.859 1.919 1.919z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-facebook-blank" viewBox="0 0 32 32">
      <title>facebook-blank</title>
      <path d="M29 0h-26c-1.65 0-3 1.35-3 3v26c0 1.65 1.35 3 3 3h13v-14h-4v-4h4v-2c0-3.306 2.694-6 6-6h4v4h-4c-1.1 0-2 0.9-2 2v2h6l-1 4h-5v14h9c1.65 0 3-1.35 3-3v-26c0-1.65-1.35-3-3-3z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-youtube-blank" viewBox="0 0 32 32">
      <title>youtube</title>
      <path d="M31.681 9.6c0 0-0.313-2.206-1.275-3.175-1.219-1.275-2.581-1.281-3.206-1.356-4.475-0.325-11.194-0.325-11.194-0.325h-0.012c0 0-6.719 0-11.194 0.325-0.625 0.075-1.987 0.081-3.206 1.356-0.963 0.969-1.269 3.175-1.269 3.175s-0.319 2.588-0.319 5.181v2.425c0 2.587 0.319 5.181 0.319 5.181s0.313 2.206 1.269 3.175c1.219 1.275 2.819 1.231 3.531 1.369 2.563 0.244 10.881 0.319 10.881 0.319s6.725-0.012 11.2-0.331c0.625-0.075 1.988-0.081 3.206-1.356 0.962-0.969 1.275-3.175 1.275-3.175s0.319-2.587 0.319-5.181v-2.425c-0.006-2.588-0.325-5.181-0.325-5.181zM12.694 20.15v-8.994l8.644 4.513-8.644 4.481z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-twitter-blank" viewBox="0 0 32 32">
      <title>twitter</title>
      <path d="M32 7.075c-1.175 0.525-2.444 0.875-3.769 1.031 1.356-0.813 2.394-2.1 2.887-3.631-1.269 0.75-2.675 1.3-4.169 1.594-1.2-1.275-2.906-2.069-4.794-2.069-3.625 0-6.563 2.938-6.563 6.563 0 0.512 0.056 1.012 0.169 1.494-5.456-0.275-10.294-2.888-13.531-6.862-0.563 0.969-0.887 2.1-0.887 3.3 0 2.275 1.156 4.287 2.919 5.463-1.075-0.031-2.087-0.331-2.975-0.819 0 0.025 0 0.056 0 0.081 0 3.181 2.263 5.838 5.269 6.437-0.55 0.15-1.131 0.231-1.731 0.231-0.425 0-0.831-0.044-1.237-0.119 0.838 2.606 3.263 4.506 6.131 4.563-2.25 1.762-5.075 2.813-8.156 2.813-0.531 0-1.050-0.031-1.569-0.094 2.913 1.869 6.362 2.95 10.069 2.95 12.075 0 18.681-10.006 18.681-18.681 0-0.287-0.006-0.569-0.019-0.85 1.281-0.919 2.394-2.075 3.275-3.394z"></path>
    </symbol>
    <symbol id="oxy-social-icons-icon-instagram-blank" viewBox="0 0 32 32">
      <title>instagram</title>
      <path d="M16 2.881c4.275 0 4.781 0.019 6.462 0.094 1.563 0.069 2.406 0.331 2.969 0.55 0.744 0.288 1.281 0.638 1.837 1.194 0.563 0.563 0.906 1.094 1.2 1.838 0.219 0.563 0.481 1.412 0.55 2.969 0.075 1.688 0.094 2.194 0.094 6.463s-0.019 4.781-0.094 6.463c-0.069 1.563-0.331 2.406-0.55 2.969-0.288 0.744-0.637 1.281-1.194 1.837-0.563 0.563-1.094 0.906-1.837 1.2-0.563 0.219-1.413 0.481-2.969 0.55-1.688 0.075-2.194 0.094-6.463 0.094s-4.781-0.019-6.463-0.094c-1.563-0.069-2.406-0.331-2.969-0.55-0.744-0.288-1.281-0.637-1.838-1.194-0.563-0.563-0.906-1.094-1.2-1.837-0.219-0.563-0.481-1.413-0.55-2.969-0.075-1.688-0.094-2.194-0.094-6.463s0.019-4.781 0.094-6.463c0.069-1.563 0.331-2.406 0.55-2.969 0.288-0.744 0.638-1.281 1.194-1.838 0.563-0.563 1.094-0.906 1.838-1.2 0.563-0.219 1.412-0.481 2.969-0.55 1.681-0.075 2.188-0.094 6.463-0.094zM16 0c-4.344 0-4.887 0.019-6.594 0.094-1.7 0.075-2.869 0.35-3.881 0.744-1.056 0.412-1.95 0.956-2.837 1.85-0.894 0.888-1.438 1.781-1.85 2.831-0.394 1.019-0.669 2.181-0.744 3.881-0.075 1.713-0.094 2.256-0.094 6.6s0.019 4.887 0.094 6.594c0.075 1.7 0.35 2.869 0.744 3.881 0.413 1.056 0.956 1.95 1.85 2.837 0.887 0.887 1.781 1.438 2.831 1.844 1.019 0.394 2.181 0.669 3.881 0.744 1.706 0.075 2.25 0.094 6.594 0.094s4.888-0.019 6.594-0.094c1.7-0.075 2.869-0.35 3.881-0.744 1.050-0.406 1.944-0.956 2.831-1.844s1.438-1.781 1.844-2.831c0.394-1.019 0.669-2.181 0.744-3.881 0.075-1.706 0.094-2.25 0.094-6.594s-0.019-4.887-0.094-6.594c-0.075-1.7-0.35-2.869-0.744-3.881-0.394-1.063-0.938-1.956-1.831-2.844-0.887-0.887-1.781-1.438-2.831-1.844-1.019-0.394-2.181-0.669-3.881-0.744-1.712-0.081-2.256-0.1-6.6-0.1v0z"></path>
      <path d="M16 7.781c-4.537 0-8.219 3.681-8.219 8.219s3.681 8.219 8.219 8.219 8.219-3.681 8.219-8.219c0-4.537-3.681-8.219-8.219-8.219zM16 21.331c-2.944 0-5.331-2.387-5.331-5.331s2.387-5.331 5.331-5.331c2.944 0 5.331 2.387 5.331 5.331s-2.387 5.331-5.331 5.331z"></path>
      <path d="M26.462 7.456c0 1.060-0.859 1.919-1.919 1.919s-1.919-0.859-1.919-1.919c0-1.060 0.859-1.919 1.919-1.919s1.919 0.859 1.919 1.919z"></path>
    </symbol>
  </defs>
</svg>
<style id='nta-wabutton-style-inline-css'>
  #nta-wabutton-626 .wa__stt_online {
    background: ;
  }

  #nta-wabutton-626 .wa__stt_online {
    color: ;
  }

  #nta-wabutton-626 .wa__stt_online .wa__cs_name {
    color: ;
    opacity: 0.8;
  }

  #nta-wabutton-626 p {
    display: none;
  }
</style>
<script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script src="https://balitravel.store/js/hoverIntent.min.js" id="hoverIntent-js"></script>
<script src="https://balitravel.store/js/maxmegamenu.js" id="megamenu-js"></script>
<script id="gt_widget_script_75268953-js-before">
      window.gtranslateSettings = /* document.write */ window.gtranslateSettings || {};
  window.gtranslateSettings['75268953'] = {
    "default_language": "en",
    "languages": ["af", "sq", "am", "ar", "hy", "az", "eu", "be", "bn", "bs", "bg", "ca", "ceb", "ny", "zh-CN", "zh-TW", "co", "hr", "cs", "da", "nl", "en", "eo", "et", "tl", "fi", "fr", "fy", "gl", "ka", "de", "el", "gu", "ht", "ha", "haw", "iw", "hi", "hmn", "hu", "is", "ig", "id", "ga", "it", "ja", "jw", "kn", "kk", "km", "ko", "ku", "ky", "lo", "la", "lv", "lt", "lb", "mk", "mg", "ms", "ml", "mt", "mi", "mr", "mn", "my", "ne", "no", "ps", "fa", "pl", "pt", "pa", "ro", "ru", "sm", "gd", "sr", "st", "sn", "sd", "si", "sk", "sl", "so", "es", "su", "sw", "sv", "tg", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "cy", "xh", "yi", "yo", "zu"],
    "url_structure": "none",
    "wrapper_selector": "#gt-wrapper-75268953",
    "select_language_label": "Select Language",
    "horizontal_position": "inline",
    "flags_location": "\/wp-content\/plugins\/gtranslate\/flags\/"
  };
</script>
<script src="https://balitravel.store/js/dropdown.js" data-no-optimize="1" data-no-minify="1" data-gt-orig-url="/" data-gt-orig-domain="www.travelholidaybali.com" data-gt-widget-id="75268953" defer></script>
<script id="sbi_scripts-js-extra">
  var sb_instagram_js_options = {
    "font_method": "svg",
    "resized_url": "https:\/\/www.travelholidaybali.com\/wp-content\/uploads\/sb-instagram-feed-images\/",
    "placeholder": "https:\/\/www.travelholidaybali.com\/wp-content\/plugins\/instagram-feed\/img\/placeholder.png",
    "ajax_url": "https:\/\/www.travelholidaybali.com\/wp-admin\/admin-ajax.php"
  };
</script>
<script src="https://balitravel.store/js/sbi-scripts.min.js" id="sbi_scripts-js"></script>
<script src="https://balitravel.store/js/unslider-min.js" id="oxygen-unslider-js"></script>
<script src="https://balitravel.store/js/jquery.event.move.js" id="oxygen-event-move-js"></script>
<script src="https://balitravel.store/js/jquery.event.swipe.js" id="oxygen-event-swipe-js"></script>
<script type="text/javascript" id="ct-footer-js"></script>

<!-- popup js -->
<script>
  function openModal(id) {
    document.getElementById("modal-" + id).style.display = "block";
  }
  function closeModal(id) {
    document.getElementById("modal-" + id).style.display = "none";
  }
// klik luar modal untuk close
  window.onclick = function(event) {
    document.querySelectorAll(".modal").forEach(function(m) {
      if (event.target === m) {
        m.style.display = "none";
      }
    });
  }
</script>

<script type="text/javascript">
  function isMobile() {
    return (/Android|webOS|iPhone|iPad|iPod|Windows Phone|IEMobile|Mobile|BlackBerry/i.test(navigator.userAgent));
  }
  var elm = jQuery('a[href*="whatsapp.com"]');
  jQuery.each(elm, function(index, value) {
    var item = jQuery(value).attr('href');
    if (item.indexOf('chat') != -1) {
          //nothing
    } else if (item.indexOf('web') != -1 && isMobile()) {
      var itemLink = item;
      var newLink = itemLink.replace('web', 'api');
      jQuery(value).attr("href", newLink);
    } else if (item.indexOf('api') != -1 && !isMobile()) {
      var itemLink = item;
      var newLink = itemLink.replace('api', 'web');
      jQuery(value).attr("href", newLink);
    }
  });
</script>
</body>
</html>